#ifndef PERSON_H
#define PERSON_H

#include <iomanip>
#include<string>

using namespace std;

class Person
{
protected:
	string name; //Name of the Person
	string birthdate; //Birthday

public:
	Person();
	Person(const string&, const string&);
	~Person();

	//Setters
	void setName(const string&);
	void setBirthday(const string&);

	//Getters
	string getName() { return name; }
	string getBirthdate(){ return birthdate; }

	//Overloaded Operators 
	bool operator > (const Person &) const;
	bool operator < (const Person &) const;
	bool operator == (const Person &) const;
	bool operator != (const Person &) const;
	bool operator == (const string&) const;
	bool operator != (const string&) const;
	friend ostream& operator << (ostream &os, const Person &person);

private:
	const string parse(const string&) const;
	
};


#endif